UNIT Vcl8255;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : VCL8255.PAS
  BUT            : Composant VCL 8255 renfermant tout les contrles du PPI
  AUTEUR         : S.Claus / M.Amarantidis
  DATE           : Novembre 1996

  MODIFIE LE     : 05.12.1996  -  1.01  -  S.Claus
  RAISON         : - Ajout le type TPort
                   - Ajout les proprits ChenillardStop, ChenillardDelai et
                     ChenillardPort
                   - Ajout la mthode Chenillard

  MODIFIE LE     : 08.12.1996  -  1.02  -  S.Claus
  RAISON         : - Ajout l'tat mpIndefini pour le type TModePort
                   - Ajout le type TPortPattern
                   - Ajout les proprits PatternPorts, PatternStop,
                     PatternNbErreurs, PatternMessage et PatternNbOK
                   - Ajout la mthode Pattern
                   - Ajout l'vnement OnErrorPattern

  MODIFIE LE     : 08.12.1996  -  1.03  -  S.Claus
  RAISON         : - Correction de la procdure Chenillard: Un port en sortie,
                     deux ports en entre.
                   - Correction de la procdure Chenillard: Lors de la mise  1
                     du bit, il faut soustraire 1  NoBit car la procdure
                     SetBitB va de 0  7 et non pas de 1  8
                   - Ajout l'vnement OnChenillardBouge pour une utilisation
                     dans le programme.

  MODIFIE LE     : 14.12.1996  -  1.04  -  S.Claus
  RAISON         : - Quelques adaptations en vue de l'utilisation de ce
                     composant sous Delphi 2.0

  MODIFIE LE     : 22.12.1996  -  1.05  -  S.Claus
                   - Chang le type des proprits PatternNbErreurs et
                     PatternNbOK de WORD  LONGINT car sinon, on peut passer en
                     ngatif.
                   - Ajout la proprit Version afin de pouvoir lire la
                     version de la VCL depuis le programme appelant.

  MODIFIE LE     : 08.01.1997  -  1.06  -  M.Amarantidis
                   - Correction du chenillard pour n'allumer qu'une LED  la
                     fois et non pas n'importe quoi.

  MODIFIE LE     : 15.01.1997  -  1.07  -  S.Claus
                   - Ajout de nouveaux type de tests de pattern, en utilisant
                     uniquement deux ports: un en mission et un un rception.
                     Seul un des ports est configur en sortie. Ces nouveaux
                     paramtres sont: ppAB, ppAC, ppBA, ppBC, ppCA et ppCB
                   - Empche toute modification de l'tat des ports si le
                     chenillard ou le test de pattern est en cours d'excution
                   - N'excute pas une seconde fois le Chenillard ou le test de
                     pattern si une de ces deux procdures est dj en cours
                     d'excution.

  MODIFIE LE     : 22.01.1997  -  1.08  -  M.Amarantidis
                   - Modification pour la configuration des modes des ports:
                     rcrit chaque fois la configuration complte du port, car
                     la lecture du mot de contrle est INTERDITE.

  REMARQUES      : - Pour la configuration du 8255, la structure du mot de
                     contrle qu'il faut crire  l'adresse de contrle est la
                     suivante:

                     D7 D6 D5 D4 D3 D2 D1 D0
                                   
                       +--+                GROUPE B
                                    +----- Port C (bas):
                                           1: Entre / 0: Sortie
                                  +-------- Port B:
                                            1: Entre / 0: Sortie
                                +----------- Slection de mode:
                                             0: Mode 0 / 1: Mode 1
                              
                                             GROUPE A
                              +-------------- Port C (haut):
                                              1: Entre / 0: Sortie
                            +----------------- Port A:
                                               1: Entre / 0: Sortie
                       +----------------------- Slection de mode:
                                                00: Mode 0 / 01: Mode 1
                                                1X: Mode 2
                     
                     +-------------------------- Drapeau de mode dfini:
                                                 1: Actif

                   - Dans cette VCL, le 8255 n'est utilis que dans le mode 0,
                     qui est un mode d'entre/sortie simple.

                   - Les proprits PatternNbOK et PatternMessage sont en
                     lecture seule et ne peuvent tre vues avec l'inspecteur
                     d'objet.

 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}


USES
  WinTypes, WinProcs, Classes, SysUtils;


CONST
  versionvcl            = '1.08';                            { Version du VCL }
  adressebase           = $300;                     { Adresse de base du 8255 }
  nbpas = 100;                            { Pattern pour le test de transfert }
  patterntest : ARRAY[1..nbpas] OF BYTE =
                       ($00, $01, $02, $03, $04, $05, $06, $07, $08, $09,
                        $10, $11, $12, $13, $14, $15, $16, $17, $18, $19,
                        $20, $21, $22, $23, $24, $25, $26, $27, $28, $29,
                        $30, $31, $32, $33, $34, $35, $36, $37, $38, $39,
                        $40, $41, $42, $43, $44, $45, $46, $47, $48, $49,
                        $50, $51, $52, $53, $54, $55, $56, $57, $58, $59,
                        $60, $61, $62, $63, $64, $65, $66, $67, $68, $69,
                        $70, $71, $72, $73, $74, $75, $76, $77, $78, $79,
                        $80, $81, $82, $83, $84, $85, $86, $87, $88, $89,
                        $90, $91, $92, $93, $94, $95, $96, $97, $98, $99);


TYPE
  TModePort = (mpSortie, mpEntree, mpIndefini);              { Etat des ports }
  TPort = (pPortA, pPortB, pPortC);                                    { Port }

  TPortPattern = (ppABC, ppBAC, ppCAB,              { Type de test de pattern }
  {1.07  Nouvelles configurations possibles }
                  ppAB, ppAC, ppBA, ppBC, ppCA, ppCB);


  TPPI8255 = CLASS(TComponent)
    PRIVATE { Private-dclarations ---------------------------------- PRIVATE }

      {-- Divers }
      FVersion         : STRING;
      FAdresseBase8255 : WORD;
      AdresseCtrl,
      AdressePortA,
      AdressePortB,
      AdressePortC     : WORD;
      FCanWrite        : BOOLEAN;

      {-- Configuration des ports }
      FModeDuPortA,
      FModeDuPortB,
      FModeDuPortC     : TModePort;

      {-- Chenillard }
      FStopChenillard  : BOOLEAN;
      FPortChenillard  : TPort;
      FDelaiChenillard : WORD;
      FOnChenillardBouge : TNotifyEvent;

      {-- Pattern }
      FPortsPattern    : TPortPattern;
      FStopPattern     : BOOLEAN;
      FNbErrPattern    : LONGINT;
      FNbOkPattern     : LONGINT;
      FMsgErrPattern   : STRING;
      FOnErrorPattern  : TNotifyEvent;

      {-- Divers }
      PROCEDURE AjusteAdresses;
      PROCEDURE SetAdresseBase(Adresse:WORD);
      PROCEDURE SetCanWrite(WriteEnabled:BOOLEAN);

      {-- Configuration des ports }
      PROCEDURE SetPortA(Mode:TModePort);
      PROCEDURE SetPortB(Mode:TModePort);
      PROCEDURE SetPortC(Mode:TModePort);

      {-- Lecture / Ecriture }
      FUNCTION  LitPortA:BYTE;
      PROCEDURE EcritPortA(Valeur:BYTE);
      FUNCTION  LitPortB:BYTE;
      PROCEDURE EcritPortB(Valeur:BYTE);
      FUNCTION  LitPortC:BYTE;
      PROCEDURE EcritPortC(Valeur:BYTE);

      {-- Chenillard }
      PROCEDURE SetFStopChenillard(Stop:BOOLEAN);
      PROCEDURE SetFPortChenillard(Valeur:TPort);
      PROCEDURE SetFDelaiChenillard(Delay:WORD);

      {-- Pattern }
      PROCEDURE SetFPortsPattern(Valeur:TPortPattern);
      PROCEDURE SetFStopPattern(Stop:BOOLEAN);

    PUBLIC { Public-dclarations ------------------------------------- PUBLIC }
      CONSTRUCTOR Create(AOwner:TComponent); OVERRIDE;
      DESTRUCTOR Destroy; OVERRIDE;

    PUBLISHED { Published declarations ---------------------------- PUBLISHED }

      {-- Divers }
      PROPERTY Enabled : BOOLEAN READ FCanWrite WRITE SetCanWrite;
      PROPERTY Adresse : WORD READ FAdresseBase8255 WRITE SetAdresseBase;
      PROPERTY Version : STRING READ FVersion;

      {-- Configuration des ports }
      PROPERTY ModePortA : TModePort READ FModeDuPortA WRITE SetPortA
                 DEFAULT mpIndefini;
      PROPERTY ModePortB : TModePort READ FModeDuPortB WRITE SetPortB
                 DEFAULT mpIndefini;
      PROPERTY ModePortC : TModePort READ FModeDuPortC WRITE SetPortC
                 DEFAULT mpIndefini;

      {-- Lecture / Ecriture }
      PROPERTY PortA : BYTE READ LitPortA WRITE EcritPortA;
      PROPERTY PortB : BYTE READ LitPortB WRITE EcritPortB;
      PROPERTY PortC : BYTE READ LitPortC WRITE EcritPortC;

      {-- Chenillard }
      PROPERTY ChenillardStop : BOOLEAN READ FStopChenillard
                  WRITE SetFStopChenillard DEFAULT TRUE;
      PROPERTY ChenillardPort : TPort READ FPortChenillard
                 WRITE SetFPortChenillard DEFAULT pPortA;
      PROPERTY ChenillardDelai : WORD READ FDelaiChenillard
                 WRITE SetFDelaiChenillard DEFAULT 300;
      PROPERTY OnChenillardBouge:TNotifyEvent READ FOnChenillardBouge
                 WRITE FOnChenillardBouge;
      PROCEDURE Chenillard; VIRTUAL;

      {-- Pattern }
      PROPERTY PatternPorts : TPortPattern READ FPortsPattern
                 WRITE SetFPortsPattern DEFAULT ppABC;
      PROPERTY PatternStop : BOOLEAN READ FStopPattern WRITE SetFStopPattern
                 DEFAULT TRUE;
      PROPERTY OnErrorPattern : TNotifyEvent READ FOnErrorPattern
                 WRITE FOnErrorPattern;
      PROPERTY PatternNbErreurs:LONGINT READ FNbErrPattern DEFAULT 0;
      PROPERTY PatternNbOK:LONGINT READ FNbOkPattern DEFAULT 0;
      PROPERTY PatternMessage:STRING READ FMsgErrPattern;
      PROCEDURE Pattern; VIRTUAL;
  END; {CLASS TPPI8255}

PROCEDURE Register;    { Enregistrement de l'objet dans l'inspecteur d'objets }


{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}


USES
  Forms, Dialogs;


{1.04  Ajout le tableau de constantes Poids }
CONST
  Poids : ARRAY[0..7] OF WORD = (1, 2, 4, 8, 16, 32, 64, 128);


TYPE
  bbit = 0..7;                                        { Pour l'accs aux bits }


{-----------------------------------------------------------------------------}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{-----------------------------------------------------------------------------}


CONSTRUCTOR TPPI8255.Create;
{ BUT: Initialisation du composant }
BEGIN
  {-- Toujours appeler le constructeur reu en hritage }
  INHERITED Create(AOwner);
  {-- Version}
  FVersion := versionvcl;
  {-- Interdiction d'crire sur tous les ports }
  FCanWrite        := FALSE;
  {-- Valeur par dfaut des adresses }
  SetAdresseBase(adressebase);
  {-- Tous les ports en entre... enfin en thorie }
  FModeDuPortA     := mpIndefini;
  FModeDuPortB     := mpIndefini;
  FModeDuPortC     := mpIndefini;
  (*SetPortA(mpEntree);   Si FCanWrite est  FALSE, cette initialisation n'est
  SetPortB(mpEntree);     pas possible . . .
  SetPortC(mpEntree); *)
  {-- Le Chenillard est arrt, 300ms d'attente entre chaque changement }
  FStopChenillard  := TRUE;
  FDelaiChenillard := 300;
  {-- Le test de pattern est arrt, pas d'erreurs, pas de message }
  FStopPattern     := TRUE;
  FNbErrPattern    := 0;
  FNbOkPattern     := 0;
  FMsgErrPattern   := '';
END; {CONSTRUCTOR Create}


DESTRUCTOR TPPI8255.Destroy;
{ BUT: Tout remettre en ordre quand on a fini }
BEGIN
  { Toujours appeler le destructor hrit }
  INHERITED Destroy;
END; {DESTRUCTOR Destroy}


{-----------------------------------------------------------------------------}
{ ACCES BAS NIVEAU ----------------------------------------- Accs bas niveau }
{-----------------------------------------------------------------------------}

(*
FUNCTION InPortB(LePort:WORD):BYTE;
{ BUT: Lecture de l'tat d'un port }
VAR
  Valeur : BYTE;
BEGIN
  {1.04  Sauvegarde et restauration du registre DX }
  ASM
    PUSH DX
    MOV  DX, LePort
    IN   AL, DX
    MOV  Valeur, AL
    POP  DX
  END; {ASM}
  InPortB := Valeur;
END; {FUNCTION InPortB}


PROCEDURE OutPortB(LePort:WORD; Value:BYTE); ASSEMBLER;
{ BUT: Ecriture sur un port }
{1.04  Sauvegarde et restauration du registre DX }
ASM
  PUSH  DX
  MOV   DX, LePort
  MOV   AL, Value
  OUT   DX, AL
  POP   DX
END; {PROCEDURE OutPortB}
*)

FUNCTION InPortB(LePort:WORD):BYTE;
BEGIN
  Result  := Port[LePort];
END; {FUNCTION InPortB}

PROCEDURE OutPortB(LePort:WORD; Value:BYTE);
BEGIN
  Port[LePort] := Value;
END; {PROCEDURE OutPortB}


(*1.04  Remplac ces procdure en assembleur par un simple test logique ...
PROCEDURE SetBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
{ BUT: Mise  1 d'un bit }
ASM
  MOV CL, bit
  MOV BL, 1
  SHL BL, CL
  LES DI, B
  OR ES:[DI], BL  {OR positionne le bit}
END; {PROCEDURE SetBitB}


PROCEDURE ClearBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
{ BUT: Mise  0 d'un bit }
ASM
  MOV CL, bit
  MOV BL, 1
  SHL BL, CL
  NOT BL
  LES DI, B
  AND ES:[DI], BL {AND of NOT BL met  zro le bit}
END; {PROCEDURE ClearBitB} *)


PROCEDURE SetBitB(VAR B : Byte; bit : bbit);
{ BUT: Mise  1 d'un bit }
BEGIN
  B := B OR Poids[bit]
END;


PROCEDURE ClearBitB(VAR B : Byte; bit : bbit);
{ BUT: Mise  0 d'un bit}
BEGIN
  B := B AND NOT Poids[bit];
END;


(*1.04  Supprim cette procdure qui n'est pas utilise
PROCEDURE ToggleBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
{ BUT: Inverse l'tat d'un bit (0->1 et 1->0) }
ASM
  MOV CL, bit
  MOV BL, 1
  SHL BL, CL
  LES DI, B
  XOR ES:[DI], BL {XOR bascule le bit}
END; {PROCEDURE ToggleBitB} *)


{-----------------------------------------------------------------------------}
{ UTILITAIRES --------------------------------------------------- Utilitaires }
{-----------------------------------------------------------------------------}


(*1.04  Remplac GetTick par GetTickCount + Simplification
FUNCTION Delay(DelayMS:LONGINT):BOOLEAN;
{ BUT: Remplace la fonction DELAY qui existrait sous DOS
  ENTREE: DelayMS = Dlai d'attente en MS
  SORTIE: TRUE s'il a t demand  l'application de quitter }
VAR
  ET : LONGINT;

FUNCTION GetTick:LONGINT;
{ BUT: Indique depuis combien de temps Windows est en fonction }
VAR
  TI:TTimerInfo;
BEGIN
  {Initialise la taille du RECORD TTimerInfo }
  TI.dwSize := SizeOf(TI);
  TimerCount(@TI);
  { Retourne le temps coul }
  Result := TI.dwmsThisVM;
END; {FUNCTION GetTick:LONGINT}

BEGIN {FUNCTION Delay}
  ET := GetTick;
  {1.04  Cette initialisation est inutile
  Result := FALSE; }
  REPEAT
    Application.ProcessMessages;
  UNTIL Application.Terminated OR (GetTick-ET > DelayMS);
  Result := Application.Terminated;
END;{FUNCTION Delay} *)


FUNCTION Delay(DelayMS:LONGINT):BOOLEAN;
{ BUT: Remplace la fonction DELAY qui existrait sous DOS
  ENTREE: DelayMS = Dlai d'attente en MS
  SORTIE: TRUE s'il a t demand  l'application de quitter }
VAR
  ET : LONGINT;
BEGIN {FUNCTION Delay}
  ET := GetTickCount;
  REPEAT
    Application.ProcessMessages;
  UNTIL Application.Terminated OR (GetTickCount-ET > DelayMS);
  Result := Application.Terminated;
END;{FUNCTION Delay}


PROCEDURE Register;
{ BUT: Ajoute ce composant dans la palette des composants de Delphi}
BEGIN
  RegisterComponents('More...', [TPPI8255]);
END; {PROCEDURE Register}


{-----------------------------------------------------------------------------}
{ ENTREE/SORTIE ----------------------------------------------- Entre/Sortie }
{-----------------------------------------------------------------------------}


PROCEDURE TPPI8255.SetCanWrite(WriteEnabled:BOOLEAN);
{ BUT: Autorise ou non l'criture sur les ports }
BEGIN
  FCanWrite := WriteEnabled;
END; {PROCEDURE SetCanWrite}


PROCEDURE TPPI8255.AjusteAdresses;
{ BUT: Ajuste toutes les adresses du 8255 en fonction de l'adresse de base }
BEGIN
  AdressePortA := FAdresseBase8255 + 0;
  AdressePortB := FAdresseBase8255 + 1;
  AdressePortC := FAdresseBase8255 + 2;
  AdresseCtrl  := FAdresseBase8255 + 3;
END; {PROCEDURE TPPI8255.AjusteAdresses}


PROCEDURE TPPI8255.SetAdresseBase(Adresse:WORD);
{ BUT: Configuration de l'adresse de base }
BEGIN
  FAdresseBase8255 := Adresse;
  AjusteAdresses;
END; {PROCEDURE TPPI8255.SetAdresseBase}


PROCEDURE TPPI8255.SetPortA(Mode:TModePort);
{ BUT: Initialisation du port A en entre ou en sortie }
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
     AND FStopChenillard AND FStopPattern THEN BEGIN
    FModeDuPortA := Mode;                               { MAJ de la proprit }
    {ValeurControle := InPortB(AdresseCtrl);     { Valeur de contrle actuelle }
    ValeurControle := Port[AdresseCtrl];     { Valeur de contrle actuelle }
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4); {A Sortie}
    IF FModeDuPortA = mpEntree THEN SetBitB  (ValeurControle, 4); {A Entree}
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1); {B Sortie}
    IF FModeDuPortB = mpEntree THEN SetBitB  (ValeurControle, 1); {B Entree}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0); {C Sortie}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3); {C Sortie}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 0); {C Entree}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 3); {C Entree}
    OutPortB(AdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortA}


PROCEDURE TPPI8255.SetPortB(Mode:TModePort);
{ BUT: Initialisation du port B en entre ou en sortie }
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
     AND FStopChenillard AND FStopPattern THEN BEGIN
    FModeDuPortB := Mode;                               { MAJ de la proprit }
    {ValeurControle := InPortB(AdresseCtrl);     { Valeur de contrle actuelle }
    ValeurControle := Port[AdresseCtrl];     { Valeur de contrle actuelle }
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4); {A Sortie}
    IF FModeDuPortA = mpEntree THEN SetBitB  (ValeurControle, 4); {A Entree}
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1); {B Sortie}
    IF FModeDuPortB = mpEntree THEN SetBitB  (ValeurControle, 1); {B Entree}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0); {C Sortie}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3); {C Sortie}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 0); {C Entree}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 3); {C Entree}
    OutPortB(AdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortB}


PROCEDURE TPPI8255.SetPortC(Mode:TModePort);
{ BUT: Initialisation du port C en entre ou en sortie }
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
     AND FStopChenillard AND FStopPattern THEN BEGIN
    FModeDuPortC := Mode;                               { MAJ de la proprit }
    {ValeurControle := InPortB(AdresseCtrl);     { Valeur de contrle actuelle }
    ValeurControle := Port[AdresseCtrl];     { Valeur de contrle actuelle }
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4); {A Sortie}
    IF FModeDuPortA = mpEntree THEN SetBitB  (ValeurControle, 4); {A Entree}
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1); {B Sortie}
    IF FModeDuPortB = mpEntree THEN SetBitB  (ValeurControle, 1); {B Entree}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0); {C Sortie}
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3); {C Sortie}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 0); {C Entree}
    IF FModeDuPortC = mpEntree THEN SetBitB  (ValeurControle, 3); {C Entree}
    OutPortB(AdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortC}


FUNCTION TPPI8255.LitPortA:BYTE;
{ BUT: Lit la valeur actuellement prsente sur le port A }
BEGIN
  Result := InPortB(AdressePortA)
END; {FUNCTION LitPortA}


PROCEDURE TPPI8255.EcritPortA(Valeur:BYTE);
{ BUT: Ecrit une valeur sur le port A }
BEGIN
  { On ne peut crire sur un port uniquement s'il est en sortie et si la
    proprit Enabled (CanWrite) est  TRUE }
  IF FCanWrite AND (FModeDuPortA = mpSortie) THEN BEGIN
    OutPortB(AdressePortA, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortA}


FUNCTION TPPI8255.LitPortB:BYTE;
{ BUT: Lit la valeur actuellement prsente sur le port B }
BEGIN
  Result := InPortB(AdressePortB)
END; {FUNCTION LitPortB}


PROCEDURE TPPI8255.EcritPortB(Valeur:BYTE);
{ BUT: Ecrit une valeur sur le port B }
BEGIN
  IF FCanWrite AND (FModeDuPortB = mpSortie) THEN BEGIN
    OutPortB(AdressePortB, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortB}


FUNCTION TPPI8255.LitPortC:BYTE;
{ BUT: Lit la valeur actuellement prsente sur le port C }
BEGIN
  Result := InPortB(AdressePortC)
END; {FUNCTION LitPortC}


PROCEDURE TPPI8255.EcritPortC(Valeur:BYTE);
{ BUT: Ecrit une valeur sur le port C }
BEGIN
  IF FCanWrite AND (FModeDuPortC = mpSortie) THEN BEGIN
    OutPortB(AdressePortC, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortC}


{-----------------------------------------------------------------------------}
{ CHENILLARD ----------------------------------------------------- Chenillard }
{-----------------------------------------------------------------------------}


PROCEDURE TPPI8255.SetFStopChenillard(Stop:BOOLEAN);
{ BUT: Arrte le Chenillard en mettant  TRUE la variable FStopChenillard}
BEGIN
  FStopChenillard := Stop;
END;


PROCEDURE TPPI8255.SetFPortChenillard(Valeur:TPort);
{ BUT: Change le port du Chenillard }
BEGIN
   { Arrte le chenillard s'il tait en train de tourner }
   SetFStopChenillard(TRUE);
   { Change l'tat du port }
   FPortChenillard := Valeur;
END; {PROCEDURE SetFPortChenillard}


PROCEDURE TPPI8255.SetFDelaiChenillard(Delay:WORD);
{ BUT: Fixe la vitesse du Chenillard, entre 0 et 65535 (~1 minute) d'attente
       entre chaque changement de bit }
BEGIN
  FDelaiChenillard := Delay;
END; {PROCEDURE SetFDelaiChenillard}


PROCEDURE TPPI8255.Chenillard;
{ BUT: Effet de Chenillard sur un des ports }
VAR
  EtatPort : BYTE;                                      { Etat actuel du port }
  Sens     : SHORTINT;                       { Sens de dplacement du bit  1 }
  NoBit    : SHORTINT;                                { No du bit qui est  1 }
BEGIN
  {-- Initialisations }
  EtatPort := 0;
  Sens     := +1;
  NoBit    := 0;

  {-- Arrte le test de pattern, et quitte cette procdure }
  IF NOT FStopPattern THEN BEGIN
    SetFStopPattern(TRUE);
    {1.07  Quitte la procdure si le pattern est en cours de test }
    Exit;
  END {IF}
  ELSE IF NOT FStopChenillard THEN BEGIN
    {1.07  Quitte la procdure si le chenillard est dj activ }
    Exit;
  END; {IF}

  {-- Set des ports en fonction du port choisi pour le chenillard }
  CASE FPortChenillard OF
    pPortA : BEGIN
               SetPortA(mpSortie);
               SetPortB(mpEntree);
               SetPortC(mpEntree);
               EcritPortA(EtatPort);
             END; {BRANCH OF CASE}
    pPortB : BEGIN
               SetPortA(mpEntree);
               SetPortB(mpSortie);
               SetPortC(mpEntree);
               EcritPortB(EtatPort);
             END; {BRANCH OF CASE}
    pPortC : BEGIN
               SetPortA(mpEntree);
               SetPortB(mpEntree);
               SetPortC(mpSortie);
               EcritPortC(EtatPort);
             END; {BRANCH OF CASE}
  END; {CASE OF}

  {-- Chenillard style K2000 }
  FStopChenillard := FALSE;                                  { C'est parti !! }
  REPEAT
    IF Sens > 0 THEN BEGIN                    { Dplacement de la LED allume }
      NoBit := NoBit + 1;
      IF NoBit > 8 THEN BEGIN                                 { Dbordement ? }
        Sens := -1;                           { Oui, alors changement de sens }
        NoBit := NoBit - 2;
      END; {IF}
    END {IF}
    ELSE BEGIN
      NoBit := NoBit - 1;
      IF NoBit < 1 THEN BEGIN                                 { Dbordement ? }
        Sens := +1;                           { Oui, alors changement de sens }
        NoBit := NoBit + 2;
      END; {IF}
    END; {ELSE}
    {1.06  Remplace le ClearBitB par un := 0, car sinon, on affiche
     n'importe quoi ! }
    {ClearBitB(EtatPort, NoBit);                                  { RAZ du bit }
    EtatPort := 0;
    {1.03  NoBit-1, pas NoBit, car SetBitB va de 0  7 et non pas de 1  8 }
    SetBitB(EtatPort, NoBit-1);                            { Mise  un du bit }
    CASE FPortChenillard OF                              { Sortie sur le port }
      pPortA : EcritPortA(EtatPort);
      pPortB : EcritPortB(EtatPort);
      pPortC : EcritPortC(EtatPort);
    END; {CASE OF}

    IF Assigned(FOnChenillardBouge) THEN BEGIN
      FOnChenillardBouge(Self);                      { Signale que a a boug }
    END; {IF}

    IF Delay(FDelaiChenillard) THEN BEGIN            { On attend un moment... }
      {Il a t demand de quitter l'application, alors on arrte ! }
      FStopChenillard := TRUE;
    END; {IF}
    Application.ProcessMessages;            { Laisse Windows faire son boulot }
  UNTIL FStopChenillard;                                        { On arrte ? }

  CASE FPortChenillard OF                         { Met la valeur du port  0 }
    pPortA : EcritPortA(0);
    pPortB : EcritPortB(0);
    pPortC : EcritPortC(0);
  END; {CASE OF}

  IF Assigned(FOnChenillardBouge) THEN BEGIN
    FOnChenillardBouge(Self);                        { Signale que a a boug }
  END; {IF}

END; {PROCEDURE Chenillard}


{-----------------------------------------------------------------------------}
{ PATTERN ----------------------------------------------------------- Pattern }
{-----------------------------------------------------------------------------}


PROCEDURE TPPI8255.SetFPortsPattern(Valeur:TPortPattern);
{ BUT: Choix des ports  utiliser pour le test de pattern }
BEGIN
  { Arrte le chenillard s'il tait en train de tourner }
  SetFStopChenillard(TRUE);
  { Choix des ports  utiliser pour le test de pattern }
  FPortsPattern := Valeur;
END; {PROCEDURE SetFPortsPattern}


PROCEDURE TPPI8255.SetFStopPattern(Stop:BOOLEAN);
{ BUT: Permet d'arrter le test en mettant FStopPattern  TRUE }
BEGIN
  FStopPattern := Stop;
END; {PROCEDURE SetFStopPattern}


PROCEDURE TPPI8255.Pattern;
{ BUT: Test de transfert de donnes entre deux ports }
VAR
  NoPattern : INTEGER;
  LuA,
  LuB,
  LuC       : BYTE;
  MessageErr : STRING;
BEGIN

  {-- Arrte le chenillard }
  IF NOT FStopChenillard THEN BEGIN
    SetFStopChenillard(TRUE);
    {1.07  Quitte la procdure si le chenillard est en cours de fonctionnement }
    Exit;
  END {IF}
  ELSE IF NOT FStopPattern THEN BEGIN
    {1.07  Quitte la procdure si le test de pattern est dj activ }
    Exit;
  END; {IF}

  {-- Set des ports en fonction du port choisi pour le chenillard }
  {1.07  Nouvelles configurations possibles }
  CASE FPortsPattern OF
    ppAB,
    ppAC,
    ppABC : BEGIN
              SetPortA(mpSortie);
              SetPortB(mpEntree);
              SetPortC(mpEntree);
            END; {BRANCH OF CASE}
    ppBA,
    ppBC,
    ppBAC : BEGIN
              SetPortA(mpEntree);
              SetPortB(mpSortie);
              SetPortC(mpEntree);
            END; {BRANCH OF CASE}
    ppCA,
    ppCB,
    ppCAB : BEGIN
              SetPortA(mpEntree);
              SetPortB(mpEntree);
              SetPortC(mpSortie);
             END; {BRANCH OF CASE}
  END; {CASE OF}

  FNbErrPattern    := 0;
  FNbOkPattern     := 0;

  FMsgErrPattern:= '';
  NoPattern        := 1;

  LuA              := 0;
  LuB              := 0;
  LuC              := 0;

  FStopPattern := FALSE;
  REPEAT
    CASE FPortsPattern OF
      ppABC : BEGIN                                      { Pattern A => B & C }
                EcritPortA(patterntest[NoPattern]);
                LuB := LitPortB;
                LuC := LitPortC;
                IF ((patternTest[NoPattern] <> LuB) OR
                    (patternTest[NoPattern] <> LuC)) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  MessageErr := MessageErr+' & C('+IntToHex(LuC, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBAC : BEGIN                                      { Pattern B => A & C }
                EcritPortB(patterntest[NoPattern]);
                LuA := LitPortA;
                LuC := LitPortC;
                IF ((patternTest[NoPattern] <> LuA) OR
                    (patternTest[NoPattern] <> LuC)) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  MessageErr := MessageErr+' & C('+IntToHex(LuC, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCAB : BEGIN                                      { Pattern C => A & B }
                EcritPortC(patterntest[NoPattern]);
                LuA := LitPortA;
                LuB := LitPortB;
                IF ((patternTest[NoPattern] <> LuA) OR
                    (patternTest[NoPattern] <> LuB)) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  MessageErr := MessageErr+' & B('+IntToHex(LuB, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      {1.07  Nouvelles configurations possibles }
      ppAB  : BEGIN                                          { Pattern A => B }
                EcritPortA(patterntest[NoPattern]);
                LuB := LitPortB;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppAC  : BEGIN                                          { Pattern A => C }
                EcritPortA(patterntest[NoPattern]);
                LuC := LitPortC;
                IF (patternTest[NoPattern] <> LuC) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> C('+IntToHex(LuC,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBA  : BEGIN                                          { Pattern B => A }
                EcritPortB(patterntest[NoPattern]);
                LuA := LitPortA;
                IF (patternTest[NoPattern] <> LuA) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBC  : BEGIN                                          { Pattern B => C }
                EcritPortB(patterntest[NoPattern]);
                LuC := LitPortC;
                IF (patternTest[NoPattern] <> LuC) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> C('+IntToHex(LuC,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCA  : BEGIN                                          { Pattern C => A }
                EcritPortC(patterntest[NoPattern]);
                LuA := LitPortA;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCB  : BEGIN                                          { Pattern C => B }
                EcritPortC(patterntest[NoPattern]);
                LuB := LitPortB;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
    END; {CASE OF}
    Inc(NoPattern);                                { Passe au pattern suivant }
    IF NoPattern > nbpas THEN BEGIN
      NoPattern := 1;
    END; {IF}
    Application.ProcessMessages;            { Laisse Windows faire son boulot }
    IF Application.Terminated THEN BEGIN
      { Il a t demand d'arrter l'application, alors on fait ce qui a t
        demand, on arrte.}
      FStopPattern := TRUE;
    END; {IF}
  UNTIL FStopPattern;

END; {PROCEDURE Pattern}


{-----------------------------------------------------------------------------}
{ THAT'S ALL -------------------------------------------------------- The end }
{-----------------------------------------------------------------------------}


INITIALIZATION
END. {INITIALIZATION UNIT Vcl8255}
