UNIT Usmall;

{-----------------------------------------------------------------------------
  NOM DE L'UNITE : USMALL.PAS
  BUT            : Test du composant PPI8255
  AUTEUR         : S.Claus
  DATE           : 8.12.1996

  MODIFIE LE     :
  RAISON         :

  REMARQUES      : Cette unit est une version (trs) light du programme
                   ETIPCBUS.
                   Aucun control n'est effectu, et il peut y avoir des
                   plante lors de l'utilisation.
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}


USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, ExtCtrls, Buttons, Vcl8255, Prevchek;


TYPE
  TfrmSmall = CLASS(TForm)
    PPI8255: TPPI8255;
    grpbxChenillard: TGroupBox;
    Label1: TLabel;
    spnedtDelai: TSpinEdit;
    grpbxPortChenillard: TRadioGroup;
    grpbxLitEcrit: TGroupBox;
    spnedtB: TSpinEdit;
    spnedtA: TSpinEdit;
    spnedtC: TSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    bitbtnClose: TBitBtn;
    grpbxPattern: TGroupBox;
    grpbxPortsPattern: TRadioGroup;
    lstbxErreursPattern: TListBox;
    Panel1: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    btnLitA: TButton;
    btnLitB: TButton;
    btnLitC: TButton;
    btnEcritA: TButton;
    btnEcritB: TButton;
    btnEcritC: TButton;
    grpbxEtatChenillard: TGroupBox;
    chkbxMontreEtat: TCheckBox;
    chkbxBit0: TCheckBox;
    chkbxBit1: TCheckBox;
    chkbxBit2: TCheckBox;
    chkbxBit3: TCheckBox;
    chkbxBit4: TCheckBox;
    chkbxBit5: TCheckBox;
    chkbxBit6: TCheckBox;
    chkbxBit7: TCheckBox;
    lblErreurs: TLabel;
    OneInstance1: TOneInstance;
    Panel2: TPanel;
    Label5: TLabel;
    lblNbErreurs: TLabel;
    bitbtnStart: TBitBtn;
    bitbtnStop: TBitBtn;
    bitbtnStartChenillard: TBitBtn;
    bitbtnStopChenillard: TBitBtn;
    PROCEDURE StartChenillardClick(Sender: TObject);
    PROCEDURE StopChenillardClick(Sender: TObject);
    PROCEDURE spnedtDelaiChange(Sender: TObject);
    PROCEDURE PortChenillard(Sender: TObject);
    PROCEDURE Lit(Sender: TObject);
    PROCEDURE Ecrit(Sender: TObject);
    PROCEDURE PortsPattern(Sender: TObject);
    PROCEDURE StartPatternClick(Sender: TObject);
    PROCEDURE StopPatternClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; VAR Action: TCloseAction);
    PROCEDURE PPI8255ErrorPattern(Sender: TObject);
    procedure PPI8255ChenillardBouge(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmSmall: TfrmSmall;


{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}


{$R *.DFM}


TYPE
  bbit = 0..7;

PROCEDURE TfrmSmall.FormCreate(Sender: TObject);
{ BUT: Initialisations lors de la cration de la fiche }
BEGIN
  PPI8255.Enabled := TRUE;
  PPI8255.Adresse := $300;
END; {PROCEDURE FormCreate}


PROCEDURE TfrmSmall.FormClose(Sender: TObject; var Action: TCloseAction);
{ BUT: Arrte tout lorsqu'on quitte }
BEGIN
  StopChenillardClick(Sender);
  StopPatternClick(Sender);
END; {PROCEDURE FormClose}


FUNCTION BitSetB(B : Byte; bit : bbit) : Boolean; ASSEMBLER;
{ BUT: Test si un des bits et  1 }
ASM
  MOV CL, bit
  MOV BL, 1
  SHL BL, CL
  MOV AL, 0       {positionne result  FALSE}
  TEST B, BL
  JZ @No
  INC AL          {positionne result  TRUE}
  @No:
END; {FUNCTION BitSetB}


{-----------------------------------------------------------------------------}
{ LECTURE/ECRITURE --------------------------------------- Lecture / Ecriture }
{-----------------------------------------------------------------------------}


PROCEDURE TfrmSmall.Lit(Sender: TObject);
{ BUT: Lit la valeur actuellement prsente sur un des ports du 8255 }
BEGIN
  CASE (Sender AS TButton).Tag OF
    1 : BEGIN
          PPI8255.ModePortA := mpEntree;
          spnedtA.Value := PPI8255.PortA;
        END; {BRANCH OF CASE}
    2 : BEGIN
          PPI8255.ModePortB := mpEntree;
          spnedtB.Value := PPI8255.PortB;
        END; {BRANCH OF CASE}
    3 : BEGIN
          PPI8255.ModePortC := mpEntree;
          spnedtC.Value := PPI8255.PortC;
        END; {BRANCH OF CASE}
  END; {CASE OF}
END; {PROCEDURE Lit}


PROCEDURE TfrmSmall.Ecrit(Sender: TObject);
{ BUT: Ecrit sur un des ports }
BEGIN
  CASE (Sender AS TButton).Tag OF
    1 : BEGIN
          PPI8255.ModePortA := mpSortie;
          PPI8255.PortA := spnedtA.Value;
        END; {BRANCH OF CASE}
    2 : BEGIN
          PPI8255.ModePortB := mpSortie;
          PPI8255.PortB := spnedtB.Value;
        END; {BRANCH OF CASE}
    3 : BEGIN
          PPI8255.ModePortC := mpSortie;
          PPI8255.PortC := spnedtC.Value;
        END; {BRANCH OF CASE}
  END; {CASE OF}
END; {PROCEDURE Ecrit}


{-----------------------------------------------------------------------------}
{ CHENILLARD ----------------------------------------------------- Chenillard }
{-----------------------------------------------------------------------------}


PROCEDURE TfrmSmall.PortChenillard(Sender: TObject);
{ BUT: Choisi le port  utiliser pour le chenillard }
BEGIN
  CASE grpbxPortChenillard.ItemIndex OF
    0 : PPI8255.ChenillardPort := pPortA;
    1 : PPI8255.ChenillardPort := pPortB;
    2 : PPI8255.ChenillardPort := pPortC;
  END; {CASE OF}
END; {PROCEDURE PortChenillard}


PROCEDURE TfrmSmall.spnedtDelaiChange(Sender: TObject);
{ BUT: Change la vitesse du chenillard }
BEGIN
  PPI8255.ChenillardDelai := spnedtDelai.Value;
END; {PROCEDURE SpinEdit1Change}


PROCEDURE TfrmSmall.StartChenillardClick(Sender: TObject);
{ BUT: Dmarre le chenillard }
BEGIN
  {-- Dsactive les autres contrles }
  grpbxPattern.Enabled := FALSE;
  grpbxLitEcrit.Enabled := FALSE;
  grpbxChenillard.Color := clRed;
  {-- Apel du chenillard }
  PPI8255.Chenillard;
END; {PROCEDURE StartChenillardClick}


PROCEDURE TfrmSmall.StopChenillardClick(Sender: TObject);
{ BUT: Arrte le chenillard }
BEGIN
  {-- Arrt du chenillard }
  PPI8255.ChenillardStop := TRUE;
  {-- Ractive les autres contrles }
  grpbxChenillard.Color := clBtnFace;
  grpbxPattern.Enabled := TRUE;
  grpbxLitEcrit.Enabled := TRUE;
END; {PROCEDURE StopChenillardClick}


{-----------------------------------------------------------------------------}
{ PATTERN ----------------------------------------------------------- Pattern }
{-----------------------------------------------------------------------------}


PROCEDURE TfrmSmall.PortsPattern(Sender: TObject);
{ BUT: Choix des ports  utiliser pour le test de pattern}
BEGIN
  CASE grpbxPortsPattern.ItemIndex OF
    0 : PPI8255.PatternPorts := ppABC; { A -> B, C }
    1 : PPI8255.PatternPorts := ppBAC; { B -> A, C }
    2 : PPI8255.PatternPorts := ppCAB; { C -> A, B }
    3 : PPI8255.PatternPorts := ppAB;  { A -> B }
    4 : PPI8255.PatternPorts := ppAC;  { A -> C }
    5 : PPI8255.PatternPorts := ppBA;  { B -> A }
    6 : PPI8255.PatternPorts := ppBC;  { B -> C }
    7 : PPI8255.PatternPorts := ppCA;  { C -> A }
    8 : PPI8255.PatternPorts := ppCB;  { C -> B }
  END; {CASE OF}
END; {PROCEDURE PortsPattern}


PROCEDURE TfrmSmall.StartPatternClick(Sender: TObject);
{ BUT: Dmarre le test de pattern }
BEGIN
  {-- Dsactive les autres contrles }
  grpbxChenillard.Enabled := FALSE;
  grpbxLitEcrit.Enabled := FALSE;
  grpbxPortsPattern.Enabled := FALSE;
  grpbxPattern.Color := clRed;
  {-- RAZ de la liste des erreurs }
  lstbxErreursPattern.Clear;
  lblNbErreurs.Caption := '';
  {-- Dmarre le test }
  PPI8255.Pattern;
END; {PROCEDURE StartPatternClick}


PROCEDURE TfrmSmall.StopPatternClick(Sender: TObject);
{ BUT: Arrte le test de pattern }
BEGIN
  {-- Arrte le test }
  PPI8255.PatternStop := TRUE;
  {-- Ractive les autres contrles }
  grpbxPattern.Color := clBtnFace;
  grpbxChenillard.Enabled := TRUE;
  grpbxLitEcrit.Enabled := TRUE;
  grpbxPortsPattern.Enabled := TRUE;
END; {PROCEDURE StopPatternClick}


PROCEDURE TfrmSmall.PPI8255ErrorPattern(Sender: TObject);
{ BUT: Affiche les erreurs de transfer lors de chaque erreur rencontre }
VAR
  TotalTests : LONGINT;
begin
  {-- Nombre total de transferts raliss }
  TotalTests := PPI8255.PatternNbOK + PPI8255.PatternNbErreurs;
  {-- Ajoute la nouvelle erreur rencontre }
  lstbxErreursPattern.Items.Add(PPI8255.PatternMessage);
  {-- Affiche le nombre d'erreurs }
  lblNbErreurs.Caption := IntToStr(PPI8255.PatternNbErreurs);
  lblNbErreurs.Caption := lblNbErreurs.Caption + ' / ' + IntToStr(TotalTests);
END; {PROCEDURE PPI8255ErrorPattern}


PROCEDURE TfrmSmall.PPI8255ChenillardBouge(Sender: TObject);
{ BUT: Affiche l'tat du port utilis pour le chenillard }
BEGIN
  IF chkbxMontreEtat.Checked THEN BEGIN
    CASE PPI8255.ChenillardPort OF
       pPortA : BEGIN
                  chkbxBit0.Checked := BitSetB(PPI8255.PortA, 0);
                  chkbxBit1.Checked := BitSetB(PPI8255.PortA, 1);
                  chkbxBit2.Checked := BitSetB(PPI8255.PortA, 2);
                  chkbxBit3.Checked := BitSetB(PPI8255.PortA, 3);
                  chkbxBit4.Checked := BitSetB(PPI8255.PortA, 4);
                  chkbxBit5.Checked := BitSetB(PPI8255.PortA, 5);
                  chkbxBit6.Checked := BitSetB(PPI8255.PortA, 6);
                  chkbxBit7.Checked := BitSetB(PPI8255.PortA, 7);
                END; {BRANCH OF CASE}
       pPortB : BEGIN
                  chkbxBit0.Checked := BitSetB(PPI8255.PortB, 0);
                  chkbxBit1.Checked := BitSetB(PPI8255.PortB, 1);
                  chkbxBit2.Checked := BitSetB(PPI8255.PortB, 2);
                  chkbxBit3.Checked := BitSetB(PPI8255.PortB, 3);
                  chkbxBit4.Checked := BitSetB(PPI8255.PortB, 4);
                  chkbxBit5.Checked := BitSetB(PPI8255.PortB, 5);
                  chkbxBit6.Checked := BitSetB(PPI8255.PortB, 6);
                  chkbxBit7.Checked := BitSetB(PPI8255.PortB, 7);
                END; {BRANCH OF CASE}
       pPortC : BEGIN
                  chkbxBit0.Checked := BitSetB(PPI8255.PortC, 0);
                  chkbxBit1.Checked := BitSetB(PPI8255.PortC, 1);
                  chkbxBit2.Checked := BitSetB(PPI8255.PortC, 2);
                  chkbxBit3.Checked := BitSetB(PPI8255.PortC, 3);
                  chkbxBit4.Checked := BitSetB(PPI8255.PortC, 4);
                  chkbxBit5.Checked := BitSetB(PPI8255.PortC, 5);
                  chkbxBit6.Checked := BitSetB(PPI8255.PortC, 6);
                  chkbxBit7.Checked := BitSetB(PPI8255.PortC, 7);
                END; {BRANCH OF CASE}
    END; {CASE OF}
  END; {IF}
END; {PROCEDURE PPI8255ChenillardBouge}


INITIALIZATION
END. {UNIT Usmall}
