UNIT Usayno;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : USAYNO.PAS
  BUT            : Ecran cach... ma HAINE du C++ !
  AUTEUR         : Stphane Claus
  DATE           : Mars 1997

  MODIFIE LE     :
  RAISON         :

  REMARQUES      : - Pour afficher cet cran: ALT-D, ALT-E, ALT-L, ALT-P,
                     ALT-H et ALT-I (ALT + DELPHI) dans la bote
                     "A propos de..."
                   - Ma vision du C++ pourrais changer suite  la venue de
                     Borland C++ Builder qui rend "Humain" le langage C
                   - Selon une enqute du Gardner Group, 90% des applications
                     dveloppes en C ne sont pas dvelops pour une interface
                     graphique (Windows p.ex.), mais tout ce qui se passe
                     derrire.
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}


USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, FxImage, Ccube, StdCtrls, Buttons, LblEffct;


TYPE
  TfrmSayNo = CLASS(TForm)
    timerCubes: TTimer;
    fximgSayNo: TFxImage;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    CubeSpin1: TCubeSpin;
    CubeSpin2: TCubeSpin;
    CubeSpin3: TCubeSpin;
    CubeSpin4: TCubeSpin;
    bitbtnClose: TBitBtn;
    lbleffWait: TLabelEffect;
    timerLabel: TTimer;
    PROCEDURE timerCubesTimer(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure timerLabelTimer(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmSayNo: TfrmSayNo;


{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}


{$R *.DFM}


VAR
  NoImage : BYTE;                                    { No de l'image affiche }
  OnPeutFermer : BOOLEAN;                       { Peut-on quitter cet cran ? }


PROCEDURE TfrmSayNo.timerCubesTimer(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Change d'image
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Les images a afficher sont dj charges. Elles sont
                    stockes dans Image1, Image2, Image3 et Image4.
 -----------------------------------------------------------------------------}
BEGIN
  { Cache le bouton Close }
  bitbtnClose.Enabled := FALSE;
  bitbtnClose.Visible := FALSE;
  { Empche la fermeture de la fentre }
  OnPeutFermer := FALSE;
  { Affiche la nouvelle image }
  CASE NoImage OF
    1 : BEGIN
          timerLabel.Enabled := FALSE;
          lbleffWait.Visible := FALSE;
          fximgSayNo.Picture := Image1.Picture;
        END; {BRANCH OF CASE}
    2 : BEGIN
          timerLabel.Enabled := FALSE;
          lbleffWait.Visible := FALSE;
          fximgSayNo.Picture := Image2.Picture;
        END; {BRANCH OF CASE}
    3 : BEGIN
          timerLabel.Enabled := FALSE;
          lbleffWait.Visible := FALSE;
          fximgSayNo.Picture := Image3.Picture;
        END; {BRANCH OF CASE}
    4 : BEGIN
          timerLabel.Enabled := FALSE;
          lbleffWait.Visible := FALSE;
          fximgSayNo.Picture := Image4.Picture;
          { DELPHI => on peut fermer la fentre }
          bitbtnClose.Enabled := TRUE;
          bitbtnClose.Visible := TRUE;
          OnPeutFermer := TRUE;
        END; {BRANCH OF CASE}
  END; {CASE OF}
  {Passe  l'image suivante}
  Inc(NoImage);
  IF NoImage > 4 THEN NoImage := 1;
END; {PROCEDURE Timer1Timer}


PROCEDURE TfrmSayNo.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Fait tourner les cubes
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  CubeSpin1.Continuous := TRUE;
  CubeSpin2.Continuous := TRUE;
  CubeSpin3.Continuous := TRUE;
  CubeSpin4.Continuous := TRUE;
  OnPeutFermer := FALSE;                 { Empche la fermeture de la fentre }
END; {PROCEDURE FormActivate}


PROCEDURE TfrmSayNo.FormClose(Sender: TObject; var Action: TCloseAction);
{-----------------------------------------------------------------------------
  BUT ........... : Fait s'arrter les cubes lors de la fermeture de la fiche
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  CubeSpin1.Continuous := FALSE;
  CubeSpin2.Continuous := FALSE;
  CubeSpin3.Continuous := FALSE;
  CubeSpin4.Continuous := FALSE;
END; {PROCEDURE FormClose}


PROCEDURE TfrmSayNo.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{-----------------------------------------------------------------------------
  BUT ........... : Valide la fermeture de la fentre
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - L'vnement OnCloseQuery se produit lors d'une action
                      fermant la fiche (lorsque la mthode Close est appele
                      ou lorsque l'utilisateur choisit Fermeture dans le menu
                      systme de la fiche). Un gestionnaire d'vnement
                      OnCloseQuery contient une variable boolenne CanClose
                      dterminant si la fiche est autorise  se fermer.
                      Pour plus d'informations sur CanClose, voir le type
                      TCloseQueryEvent.
                    - Le type TCloseQueryEvent pointe sur la mthode qui
                      dtermine si une fiche est en mesure d'tre ferme.
                      La valeur du paramtre CanClose dtermine si la fiche
                      peut tre ferme.
                      TCloseQueryEvent est le type de l'vnement OnCloseQuery.
 -----------------------------------------------------------------------------}
BEGIN
  CanClose := OnPeutFermer;                      { Peut-on fermer cette fiche }
END; {PROCEDURE FormCloseQuery}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



procedure TfrmSayNo.timerLabelTimer(Sender: TObject);
VAR
  NextAngle : INTEGER;
begin
  NextAngle := lbleffWait.Angle;
  Inc(NextAngle, 10);
  IF NextAngle > 360 THEN NextAngle := 0;
  lbleffWait.Angle := NextAngle;
end;

INITIALIZATION
  NoImage := 0;
  OnPeutFermer := FALSE;
END. {UNIT Usayno}
